//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using PerlWordCount;

class main
{
    public static void Main(string[] args)
    {
        String text = "The quick brown fox jumps over the lazy dog.";

        // Utworzenie nowego obiektu 'PerlWordCount.WordCount'; naley pamita o jego 
        // pniejszym usuniciu.
        using (WordCount obj = new WordCount(text)) {

            // Uzyskanie waciwoci 'Text'
            Console.WriteLine("Text is '{0}'", obj.Text);

            // Ustawienie waciwoci 'Text'
            obj.Text = "To be or not to be?";

            // Metoda 'Count' bez argumentw zwraca liczb sw
            Console.WriteLine("Odnaleziono {0} rnych sw w '{1}'",
                              obj.Count(), obj.Text);

            // Metoda 'Words' zwraca tablic 'String[]'
            // Metoda 'Count' zwraca liczb wystpie sowa
            foreach (String word in obj.Words())
                Console.WriteLine("{0} pojawia si {1} raza(y)", word, obj.Count(word));

            // Wywoanie 'Count' dla sowa nieznajdujcego si w 'Text' powoduje zgoszenie wyjtku
            try {
                String word = "nieznany";
                Console.WriteLine("{0} pojawia si {1} raza(y)", word, obj.Count(word));
            }
            catch (Exception e) {
                Console.WriteLine("Wyjtek: {0}", e.Message);
            }
        }
    }
}
